static char sccsid[] = "@(#)66	1.1  src/gos/2d/MOTIF/demos/xmsamplers/xmueditor.c, motifdemos, gos411, 9428A410i 2/7/94 17:40:30";

/*
 *   COMPONENT_NAME: MOTIF	Motif Demos
 *
 *   FUNCTIONS:
 *		
 *
 *   ORIGINS: 73 27
 *
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1994
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2.1
*/ 
/*
*  (c) Copyright 1989 HEWLETT-PACKARD COMPANY. */

/**---------------------------------------------------------------------
***	
***	file:		xmueditor.c
***
***	project:	Motif Widgets example programs
***
***	description:	This program is a modified version of the demo
***			"xmeditor", which allows users to import and
***			export files in different encodings, including
***			Unicode. It uses iconv to do the conversions,
***			and calls setlocale() at the beginning of the
***			program.
***	
***	defaults:	xmueditor.c depends on these defaults:
***
#
*allowShellResize:		true
*borderWidth:			0
*highlightThickness:		2
*traversalOn:			true
*keyboardFocusPolicy:		explicit
#
xmueditor*menu_bar*background:	#58f
#
***-------------------------------------------------------------------*/

/*-------------------------------------------------------------
**	Include Files
*/

#include <stdlib.h>
#include <locale.h>
#include <iconv.h>
#include <langinfo.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/XmP.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/BulletinB.h>
#include <Xm/FileSB.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/CutPaste.h>

/*-------------------------------------------------------------
**	Global Variables
*/

/* Macimum length for encoding name. */
#define MAX_CODE_LEN    256

/* Maximum ratio of bytes per character for file and locale encodings. */
#define MB_RATIO_MAX 4

#define MENU_HELP		200
#define MENU_EXIT		201
#define MENU_IMPORT		202
#define MENU_EXPORT		203
#define MENU_ENCODING		204
#define MENU_CUT		208
#define MENU_COPY		209
#define MENU_PASTE		210
#define MENU_CLEAR		211

#define DIALOG_HELP		300
#define DIALOG_XWARNING		301
#define DIALOG_FSELECT		302
#define DIALOG_EXPORT		303
#define DIALOG_ENCODING		304

/* defines a temporary file for file transfers */

Widget text;			/* multi-line text widget		    */
Widget cut_button;		/* clipboard cut button 		    */
Widget copy_button;		/* clipboard copy button 		    */
Widget paste_button;		/* clipboard paste button 		    */
Widget clear_button;		/* clipboard clear button 		    */
Widget import_dialog;		/* import file dialog   		    */
Widget exit_warning;		/* special internal selection dialog	    */
Widget export_dialog;		/* export file dialog		 	    */
Widget encoding_dialog;		/* import export code set                   */
Boolean file_saved = True;	/* indicates that the present file is saved */
char *filename = "";		/* string containing file name 		    */
char loccode [MAX_CODE_LEN];	/* string containing locale code name 	    */
char *filecode = NULL;		/* string containing file code name 	    */
iconv_t in_conv = NULL, out_conv = NULL;
int start_pos, end_pos;		/* start and end position of last action    */

XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
				/* used to set up XmStrings */

char Error[128];
XtAppContext app_context;/*  Application Context  	*/
Widget Shell1;	   /*  ApplicationShell 	*/

/*-------------------------------------------------------------
**	OpenFile - Open the present file.  Returns true if file 
**                 exists and open is sucessful.
*/

Boolean OpenFile()
{
   struct stat statbuf;		/* Information on a file. */
   int   file_length;		/* Length of file. 	  */
   int   conv_length;
   char *file_string;	        /* Contents of file. 	  */
   char *conv_string;
   char *inp, *outp;
   FILE *fp = NULL;		/* Pointer to open file   */
   XmTextPosition curs_pos;
   Arg args[10];

   /* Open file read-only. */ 
   if ((fp = fopen(filename, "r")) == NULL) {
	return(False);
    }

   if (stat(filename, &statbuf) == 0)
	 file_length = statbuf.st_size;
   else
	 file_length = 1000000; /* arbitrary file length */

   /* read the file string */
   file_string = (char *) XtMalloc((unsigned)file_length);
   fread(file_string, sizeof(char), file_length, fp);

   if (in_conv) {
	/* File code is not same as locale code. */	
	/* Allocate file string guaranteed to be long enough */
	conv_length = file_length * MB_CUR_MAX;
	conv_string = (char *) XtMalloc((unsigned)conv_length);
	inp = file_string;
	outp = conv_string;
	/* Ignore errors, do the best you can. */
	iconv(in_conv, &inp, &file_length, &outp, &conv_length);
	XtFree(file_string);
	file_string = conv_string;
   }

   /* close up the file */
   if (fclose(fp) != NULL) fprintf(stderr, "Warning: unable to close file.\n");

   /* Get cursor position */
   XtSetArg(args[0], XmNcursorPosition, &curs_pos);
   XtGetValues(text, args, 1);

   /* Insert the file string into the text widget */
   XmTextReplace(text, curs_pos, curs_pos, file_string);
   XtFree(file_string);

   file_saved = False; 
	 
   return(True);
}

/*-------------------------------------------------------------
**	SaveFile - Save the present file.
*/

Boolean SaveFile()
{
    int   file_length;		/* Length of file. 	  */
    int   conv_length;
    char *file_string = NULL;   	  /* Contents of file.		     */
    char *conv_string = NULL;
    char *inp, *outp;
    FILE *tfp;				  /* Pointer to open temporary file. */
    char namebuf[BUFSIZ]; 		  /* for "system" call below         */
    char *tempname = (char *)XtMalloc(25); /* Temporary file name.           */
    int status;

    sprintf(tempname, "%s", (_XmConst char *)mktemp("/tmp/xmeditXXXXXX"));
    
    if ((tfp = fopen(tempname, "w")) == NULL) {
       fprintf(stderr, "Warning: unable to open temp file, text not saved.\n");
       return(False);;
     }

    /* get the text string */
    file_string = (char *)XmTextGetString(text);

   if (out_conv) {
	/* File code is not same as locale code. */	
	/* Allocate file string guaranteed to be long enough */
	file_length = strlen(file_string + 1); /* add one for '\0' */
	conv_length = file_length * MB_RATIO_MAX;
	conv_string = (char *) XtMalloc((unsigned)conv_length);
	inp = file_string;
	outp = conv_string;
	/* Ignore errors, do the best you can. */
	iconv(out_conv, &inp, &file_length, &outp, &conv_length);
	if (file_string) {
	    XtFree((XtPointer)file_string);
	}
	file_string = conv_string;
   }
    /* write to a temp file */
    fwrite(file_string, sizeof(char), strlen(file_string) + 1, tfp);

    /* flush and close the temp file */
    if (fflush(tfp) != NULL) 
      fprintf(stderr,"Warning: unable to flush file.\n");

    if (fclose(tfp) != NULL) 
      fprintf(stderr,"Warning: unable to close file.\n");

    if (file_string) {
        XtFree((XtPointer)file_string); /* free the text string */
    }

    /* 
     * Move the tempname to the saved file, but do it independent
     *  of filesystem boundaries
     */

    sprintf(namebuf, "cp %s %s", tempname, filename);
    status = system(namebuf);
    unlink(tempname);

    if (status == 0) 
      {
	file_saved = True;
      } else 
	{
	  fprintf(stderr, "Warning: unable to save file.\n");
	  XtFree(tempname);
	  return(False);
	}
    XtFree(tempname);
    return(True);
}


/*-------------------------------------------------------------
**	FileChangedCB Process callback from Text.
*/
/* ARGSUSED */
void FileChangedCB(w, client_data, call_data) 
Widget    w;		/*  widget id		*/
XtPointer client_data;	/*  data from application   */
XtPointer call_data;	/*  data from widget class  */
{
  /* 
   * Set the file_saved flag to indicate that the
   *  file has been modified and the user should be
   *  notified before exiting. 
   */

    file_saved = False;
}

/*-------------------------------------------------------------
**	MenuCB - Process callback from PushButtons in PulldownMenus.
*/
/* ARGSUSED */
void MenuCB(w, client_data, call_data) 
Widget    w;		/*  widget id		*/
XtPointer client_data;	/*  data from application   */
XtPointer call_data;	/*  data from widget class  */
{
  register int n;		/* arg count		    */
  Arg args[10];			/* arg list		    */
  XmString tcs;

  switch ((int)client_data)
    {
    case MENU_IMPORT:
      /* display the file selection dialog */
      XtManageChild(import_dialog);
      break;

    case MENU_EXPORT:
      /* Display the 'export as' dialog with the
	 present filename displayed in it. */
      n = 0;
      tcs  = XmStringCreateLtoR(filename, charset);
      XtSetArg(args[n], XmNtextString, tcs); n++;
      XtSetValues(export_dialog, args, n);
      XtManageChild(export_dialog);
      break;

    case MENU_ENCODING:
      /* Display the 'encoding' dialog with the
	 present encoding displayed in it. */
      n = 0;
      tcs  = XmStringCreateLtoR(filecode, charset);
      XtSetArg(args[n], XmNtextString, tcs); n++;
      XtSetValues(encoding_dialog, args, n);
      XtManageChild(encoding_dialog);
      break;

    case MENU_EXIT:
      /* exit if there is no files open */
      if (!file_saved) {
	  XtManageChild(exit_warning);
      }
      else {
	/* exit this program */
	exit(0);
      }
      break;

    case MENU_CUT:
      {
	/* needed to get the event time */
	XmAnyCallbackStruct * cb = (XmAnyCallbackStruct *) call_data;

	/* call routine to copy selection to clipboard */
	XmTextCut(text, cb->event->xbutton.time);
      }
      break;

    case MENU_COPY:
      {
	/* needed to get the event time */
	XmAnyCallbackStruct * cb = (XmAnyCallbackStruct *) call_data;

	XmTextCopy(text, cb->event->xbutton.time);
      }
      break;

    case MENU_PASTE:
      {
	/* needed to get the event time */
	XmAnyCallbackStruct * cb = (XmAnyCallbackStruct *) call_data;

	XmTextPaste(text);
      }
      break;

    case MENU_CLEAR:
      {
        XmTextSetString(text, "");
	file_saved = True;
      }
      break;

    case MENU_HELP:
      /* no help at this time */
      break;

    default:
      /* unknown client_data was received and there is no setup 
         to handle this */
      fprintf(stderr, "Warning: in menu callback\n");
      break;
    }
}

/*-------------------------------------------------------------
**	DialogCancelCB
**		Process callback from Dialog cancel actions.
*/
static void DialogCancelCB(w, client_data, call_data) 
Widget	w;		/*  widget id		*/
XtPointer client_data;	/*  data from application   */
XtPointer call_data;	/*  data from widget class  */
{
  switch ((int)client_data)
    {
    case DIALOG_FSELECT:
      /* popdown the file selection box */
      XtUnmanageChild(import_dialog);
      break;

    case DIALOG_XWARNING:
    case DIALOG_EXPORT:
    case DIALOG_ENCODING:
    case DIALOG_HELP:
      /* no action is necessary at this time */
      break;

    default:
      /* a unknown client_data was recieved and
	 there is no setup to handle this */
      fprintf(stderr, "Warning: in cancel callback\n");
      break;
    }
}

/*-------------------------------------------------------------
**	DialogAcceptCB
**		Process callback from Dialog actions.
*/
/* ARGSUSED */
static void DialogAcceptCB(w, client_data, call_data) 
Widget w;		/*  widget id		*/
XtPointer client_data;	/*  data from application   */
XtPointer call_data;	/*  data from widget class  */
{
  
  switch ((int)client_data)
    {
    case DIALOG_FSELECT:
      /* open the file and read it into the text widget */
      if (filename != NULL) {
	XtFree(filename);
	filename = NULL;
      }
      {
	XmFileSelectionBoxCallbackStruct *fcb =
	  (XmFileSelectionBoxCallbackStruct *) call_data;

	/* get the filename from the file selection box */
	XmStringGetLtoR(fcb->value, charset, &filename);

	/* Open file, print error if it does not exist. */
	if (!OpenFile()) {
	    fprintf(stderr, "Warning: unable to open file\n");
	}
	else {
	    /* make appropriate item sensitive */
	    XtSetSensitive(cut_button, True);
	    XtSetSensitive(copy_button, True);
	    XtSetSensitive(paste_button, True);
	    XtSetSensitive(clear_button, True);
	}

	/* popdown the file selection box */
	XtUnmanageChild(import_dialog);
      }
      break;

    case DIALOG_XWARNING:
      exit(0);
      break;

    case DIALOG_EXPORT:
      {
	XmSelectionBoxCallbackStruct *scb =
	  (XmSelectionBoxCallbackStruct *) call_data;

	/* get the filename string from the file
	   selection box */
	XmStringGetLtoR(scb->value, charset, &filename);
	
	SaveFile();

	XtUnmanageChild(export_dialog);
      }
      break;

    case DIALOG_ENCODING:
      {
	char *tmpcode;
	iconv_t in_tmp, out_tmp;
	XmSelectionBoxCallbackStruct *scb =
	  (XmSelectionBoxCallbackStruct *) call_data;

	/* get the encoding string from the file
	   selection box */
	XmStringGetLtoR(scb->value, charset, &tmpcode);
	if (!strcmp(loccode, tmpcode)) {
	    /* Code sets are the same. */
	    if (in_conv) {
		iconv_close(in_conv);
		in_conv = NULL;
	    }
	    if (out_conv) {
		iconv_close(out_conv);
		out_conv = NULL;
	    }
	    filecode = tmpcode;
	}
	else {
	    in_tmp = iconv_open(loccode, tmpcode);
	    out_tmp = iconv_open(tmpcode, loccode);
	    if ((in_tmp != -1) && (out_tmp != -1) &&
		in_tmp && out_tmp) {
		in_conv = in_tmp;
		out_conv = out_tmp;
		filecode = tmpcode;
	    }
	    else {
		fprintf(stderr, "%s <-> %s conversion not supported \n", loccode, tmpcode);
	    }
	}

	XtUnmanageChild(encoding_dialog);
      }
      break;

    case DIALOG_HELP:
      /* no help at this time */
      break;

    default:
      /* unknown callback type */
      fprintf (stderr, "Warning: in accept callback\n");
      break;
    }
}

/*-------------------------------------------------------------
**	CreateMenuBar
**		Create MenuBar in MainWindow
*/

static Widget CreateMenuBar(parent)
Widget parent;
{
  Widget menu_bar;	/*  RowColumn	 		*/
  Widget cascade1;	/*  CascadeButton		*/
  Widget cascade2;	/*  CascadeButton               */
  Widget cascade3;   
  Widget menu_pane1;	/*  RowColumn	 		*/
  Widget menu_pane2;    /*  RowColumn			*/
  Widget button1, button2, button3, button4;
  Arg args[10];		/*  arg list			*/
  register int	n;	/*  arg count			*/
  XmString tcs;

  /*
   *	Create MenuArea.
   */

  n = 0;
  menu_bar = XmCreateMenuBar(parent, "menu_bar", args, n);

  /*
   *	Create "Options" PulldownMenu.
   */

  n = 0;
  menu_pane1 = XmCreatePulldownMenu(menu_bar, "menu_pane1", args, n);

  n = 0;	
  tcs = XmStringCreateLtoR("Encoding", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'c'); n++;
  button1 = XmCreatePushButton(menu_pane1, "Encoding", args, n);
  XtAddCallback(button1, XmNactivateCallback, 
		MenuCB, (XtPointer)MENU_ENCODING);
  XtManageChild(button1);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("File Encoding", charset);
  XtSetArg(args[n], XmNselectionLabelString, tcs); n++;
  encoding_dialog = XmCreatePromptDialog(parent, "encoding_dialog", args, n);
  XtAddCallback(encoding_dialog, XmNokCallback,
		DialogAcceptCB, (XtPointer)DIALOG_ENCODING);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("Import", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'I'); n++;
  button2 = XmCreatePushButton(menu_pane1, "Import", args, n);
  XtAddCallback(button2, XmNactivateCallback, MenuCB, (XtPointer)MENU_IMPORT);
  XtManageChild(button2);
  XmStringFree(tcs);

  import_dialog = XmCreateFileSelectionDialog(parent,
					    "import_file_dialog", NULL, 0);

  XtAddCallback(import_dialog, XmNokCallback,
		 DialogAcceptCB, (XtPointer)DIALOG_FSELECT);
  XtAddCallback(import_dialog, XmNcancelCallback,
		 DialogCancelCB, (XtPointer)DIALOG_FSELECT);

  n = 0;	
  tcs = XmStringCreateLtoR("Export", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'x'); n++;
  button3 = XmCreatePushButton(menu_pane1, "Export", args, n);
  XtAddCallback(button3, XmNactivateCallback, MenuCB, (XtPointer)MENU_EXPORT);
  XtManageChild(button3);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("Export as...", charset);
  XtSetArg(args[n], XmNselectionLabelString, tcs); n++;
  export_dialog = XmCreatePromptDialog(parent, "export_file_dialog", args, n);
  XtAddCallback(export_dialog, XmNokCallback,
		DialogAcceptCB, (XtPointer)DIALOG_EXPORT);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("Exit", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'E'); n++;
  button4 = XmCreatePushButton(menu_pane1, "Exit", args, n);
  XtAddCallback(button4, XmNactivateCallback, MenuCB, (XtPointer)MENU_EXIT);
  XtManageChild(button4);
  XmStringFree(tcs);

  n=0;
  tcs = XmStringCreateLtoR("Discard changes?", charset);
  XtSetArg(args[n], XmNmessageString, tcs); n++;
  XtSetArg(args[n], XmNdefaultButtonType, XmDIALOG_CANCEL_BUTTON); n++;
  exit_warning = XmCreateWarningDialog(parent, "exit_warning", args, n);
  XtAddCallback(exit_warning, XmNokCallback,
		 DialogAcceptCB, (XtPointer)DIALOG_XWARNING);
  XtAddCallback(exit_warning, XmNcancelCallback,
		 DialogCancelCB, (XtPointer)DIALOG_XWARNING);

  n = 0;
  XtSetArg(args[n], XmNsubMenuId, menu_pane1);  n++;
  tcs = XmStringCreateLtoR("File", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'F'); n++;
  cascade1 = XmCreateCascadeButton(menu_bar, "File", args, n);
  XtManageChild(cascade1);
  XmStringFree(tcs);

  /*	
   * Create "Options" PulldownMenu.
   */

  n = 0;
  menu_pane2 = XmCreatePulldownMenu(menu_bar, "menu_pane2", args, n);

  n = 0;
  tcs = XmStringCreateLtoR("Cut", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 't'); n++;
  cut_button = XmCreatePushButton(menu_pane2, "Cut", args, n);
  XtAddCallback(cut_button, XmNactivateCallback, MenuCB, (XtPointer)MENU_CUT);
  XtManageChild(cut_button);
  XtSetSensitive(cut_button, False);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("Copy", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'C'); n++;
  copy_button = XmCreatePushButton(menu_pane2, "Copy", args, n);
  XtAddCallback(copy_button, XmNactivateCallback, MenuCB, (XtPointer)MENU_COPY);
  XtManageChild(copy_button);
  XtSetSensitive(copy_button, False);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("Paste", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'P'); n++;
  paste_button = XmCreatePushButton(menu_pane2, "Paste", args, n); n++;
  XtAddCallback(paste_button, XmNactivateCallback, MenuCB, (XtPointer)MENU_PASTE);
  XtManageChild(paste_button);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("Clear All", charset);
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'e'); n++;

  /* 
   * pseudo accelerator - Text already handles this action appropriately 
   */

  clear_button = XmCreatePushButton(menu_pane2, "Clear All", args, n);
  XtAddCallback(clear_button, XmNactivateCallback, MenuCB, (XtPointer)MENU_CLEAR);
  XtManageChild(clear_button);
  XtSetSensitive(clear_button, False);
  XmStringFree(tcs);

  n = 0;
  tcs = XmStringCreateLtoR("Edit", charset);
  XtSetArg(args[n], XmNsubMenuId, menu_pane2);  n++;
  XtSetArg(args[n], XmNlabelString, tcs); n++;
  XtSetArg(args[n], XmNmnemonic, 'E'); n++;
  cascade2 = XmCreateCascadeButton(menu_bar, "Edit", args, n);
  XtManageChild(cascade2);
  XmStringFree(tcs);

  /*	Create "Help" button.
   */

  n = 0;
  cascade3 = XmCreateCascadeButton(menu_bar, "Help", args, n);
  XtAddCallback(cascade3, XmNactivateCallback, MenuCB, (XtPointer)MENU_HELP);
  XtManageChild(cascade3);

  n = 0;
  XtSetArg(args[n], XmNmenuHelpWidget, cascade3);  n++;
  XtSetValues(menu_bar, args, n);
  return(menu_bar);
}

/*-------------------------------------------------------------
**	CreateText
**		Create Text.
*/
static void CreateText(parent)
Widget parent;
{
  Arg args[10];		/*  arg list		*/
  register int n;	/*  arg count		*/

  /* create text widget */
  n = 0;
  XtSetArg(args[n], XmNrows, 24);  n++;
  XtSetArg(args[n], XmNcolumns, 80);  n++;
  XtSetArg(args[n], XmNresizeWidth, False);  n++;
  XtSetArg(args[n], XmNresizeHeight, False);  n++;
  XtSetArg(args[n], XmNscrollVertical, True);  n++;
  XtSetArg(args[n], XmNscrollHorizontal, True);  n++;
  XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT);  n++;

  text = XmCreateScrolledText(parent, "text", args, n);

  /* add value changed callback */
  XtAddCallback(text, XmNmodifyVerifyCallback, FileChangedCB, (XtPointer)NULL);

  XmTextSetString(text, "");

  return;
}

/*-------------------------------------------------------------
**	main
**		Initialize toolkit.
**		Create MainWindow and subwidgets.
**		Realize toplevel widgets.
**		Process events.
*/
void main(argc,argv)
int  argc;
char **argv;
{
  Display *display;	   /*  Display			*/
  Widget main;		   /*  MainWindow	 	*/
  Widget menu_bar;	   /*  RowColumn	 	*/

  Arg args[10];		/*  arg list		*/
  register int	n;	/*  arg count		*/
  char	*progname;  	/* program name without the full pathname */

  setlocale(LC_ALL, "");
  strcpy(loccode, nl_langinfo(CODESET));
  filecode = &(loccode[0]);
  if (progname=strrchr(argv[0], '/')){
    progname++;
  }
  else	{
    progname = argv[0];
  }

  /*	Initialize toolkit and open display.
   */

  XtToolkitInitialize();
  app_context = XtCreateApplicationContext();
  display = XtOpenDisplay(app_context, NULL, progname, "XMdemos",
			  NULL, 0, &argc, argv);
  if (!display)
    {
      XtWarning("xmueditor: can't open display, exiting...");
      exit(0);
    }
  
  /*	Create ApplicationShell.
   */
	
 Shell1 = XtAppCreateShell(progname, "XMdemos",
			       applicationShellWidgetClass, 
			       display, NULL, 0);

  /*	Create MainWindow.
   */
  n = 0;
  XtSetArg(args[n], XmNshadowThickness, 0);  n++;
  main = XmCreateMainWindow(Shell1, "main", args, n);
  XtManageChild(main);


  /*	Create MenuBar in MainWindow.
   */
  menu_bar = CreateMenuBar(main);
  XtManageChild(menu_bar);


  /*	Create Text.
   */
  CreateText(main);
  XtManageChild(text);

  XmAddTabGroup(text);

  /*	Realize toplevel widgets.
   */
  XtRealizeWidget(Shell1);

  /*	Process events.
   */
  XtAppMainLoop(app_context);
}


